/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.sound.audioswitcher;

import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.world.sound.audioswitcher.ALCHelper;
import gg.essential.api.EssentialAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AudioSwitcher {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ALCHelper alcHelper = new ALCHelper();
    private List<String> devices = new ArrayList<String>();
    private boolean previousWasOptionsSounds;
    private boolean changedDevice;
    private int buttonYPosition;

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.gui;
        List buttonList = event.buttonList;
        if (gui instanceof GuiScreenOptionsSounds) {
            this.previousWasOptionsSounds = true;
            this.devices = this.alcHelper.getAvailableDevices(true);
            String selectedAudioDevice = PatcherConfig.selectedAudioDevice;
            if (selectedAudioDevice == null || selectedAudioDevice.isEmpty()) {
                selectedAudioDevice = this.devices.isEmpty() ? "Default Sound Device" : this.devices.get(0);
            }
            for (GuiButton button : buttonList) {
                if (button.field_146127_k != 200) continue;
                String buttonText = selectedAudioDevice;
                int stringWidth = this.mc.field_71466_p.func_78256_a(buttonText);
                if (stringWidth >= 175) {
                    buttonText = this.mc.field_71466_p.func_78269_a(buttonText, 170) + "...";
                }
                this.buttonYPosition = button.field_146129_i - 44;
                buttonList.add(new GuiButton(38732, gui.field_146294_l / 2 - 100, this.buttonYPosition, buttonText));
                break;
            }
        } else if (this.previousWasOptionsSounds) {
            this.previousWasOptionsSounds = false;
            if (this.changedDevice) {
                Patcher.instance.forceSaveConfig();
                try {
                    this.mc.func_147118_V().func_110549_a(this.mc.func_110442_L());
                }
                catch (Exception e) {
                    EssentialAPI.getNotifications().push("Patcher", "Failed to reinitialize OpenAL.");
                    Patcher.instance.getLogger().error("Failed to reinitialize OpenAL.", (Throwable)e);
                }
                this.changedDevice = false;
            }
        }
    }

    @SubscribeEvent
    public void drawScreen(GuiScreenEvent.DrawScreenEvent event) {
        GuiScreen gui = event.gui;
        if (gui instanceof GuiScreenOptionsSounds) {
            gui.func_73732_a(this.mc.field_71466_p, "Sound Device (Click to Change)", gui.field_146294_l / 2, this.buttonYPosition - 12, -1);
        }
    }

    @SubscribeEvent
    public void actionPerformed(GuiScreenEvent.ActionPerformedEvent event) {
        GuiScreen gui = event.gui;
        GuiButton button = event.button;
        int buttonId = button.field_146127_k;
        if (gui instanceof GuiScreenOptionsSounds && buttonId == 38732) {
            int index;
            this.fetchAvailableDevicesUncached();
            if (this.devices.isEmpty()) {
                return;
            }
            String selectedAudioDevice = PatcherConfig.selectedAudioDevice;
            selectedAudioDevice = selectedAudioDevice != null && !selectedAudioDevice.isEmpty() ? ((index = this.devices.indexOf(selectedAudioDevice)) + 1 >= this.devices.size() ? this.devices.get(0) : this.devices.get(index + 1)) : this.devices.get(0);
            String buttonText = selectedAudioDevice;
            int stringWidth = this.mc.field_71466_p.func_78256_a(buttonText);
            if (stringWidth >= 175) {
                buttonText = this.mc.field_71466_p.func_78269_a(buttonText, 170) + "...";
            }
            PatcherConfig.selectedAudioDevice = selectedAudioDevice;
            button.field_146126_j = buttonText;
            if (!this.changedDevice) {
                this.changedDevice = true;
            }
            event.setCanceled(true);
        }
    }

    public void fetchAvailableDevicesUncached() {
        this.devices = this.alcHelper.getAvailableDevices(false);
    }

    public List<String> getDevices() {
        return this.devices;
    }
}

